<?php

/**
 * Title: Featured Content
 * Slug: infinix/featured-content
 * Categories: infinix, page
 */
?>

<!-- wp:group {"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|80"}}},"className":"wp-section-block wp-featured-content","layout":{"inherit":true,"type":"constrained"}} -->
<div class="wp-block-group alignfull wp-section-block wp-featured-content" style="padding-top:var(--wp--preset--spacing--80)"><!-- wp:group {"align":"wide","style":{"spacing":{"padding":{"top":"0","bottom":"0"},"margin":{"bottom":"28px"},"blockGap":"7px"}},"className":"wp-section-header-block","layout":{"type":"default"}} -->
	<div class="wp-block-group alignwide wp-section-header-block" style="margin-bottom:28px;padding-top:0;padding-bottom:0"><!-- wp:group {"style":{"spacing":{"blockGap":"0px"}},"layout":{"type":"constrained","justifyContent":"left"}} -->
		<div class="wp-block-group"><!-- wp:paragraph {"align":"left","fontSize":"normal"} -->
			<p class="has-text-align-left has-normal-font-size"><?php esc_html_e('Articles', 'infinix') ?></p>
			<!-- /wp:paragraph -->

			<!-- wp:heading {"textAlign":"left","style":{"typography":{"fontStyle":"normal","fontWeight":"400"}}} -->
			<h2 class="wp-block-heading has-text-align-left" style="font-style:normal;font-weight:400"><?php esc_html_e('Featured', 'infinix') ?></h2>
			<!-- /wp:heading -->
		</div>
		<!-- /wp:group -->
	</div>
	<!-- /wp:group -->

	<!-- wp:group {"align":"wide","className":"wp-block-group-content"} -->
	<div class="wp-block-group alignwide wp-block-group-content"><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"40px","left":"40px"}}}} -->
		<div class="wp-block-columns alignwide"><!-- wp:column -->
			<div class="wp-block-column"><!-- wp:group {"className":"wp-block-post-group"} -->
				<div class="wp-block-group wp-block-post-group"><!-- wp:image {"id":1886,"sizeSlug":"full","linkDestination":"none"} -->
					<figure class="wp-block-image size-full"><img src="<?php echo get_parent_theme_file_uri('/assets/images/featured-content-1.jpg'); ?>" alt="" class="wp-image-1886" /></figure>
					<!-- /wp:image -->

					<!-- wp:group {"style":{"spacing":{"blockGap":"20px"}},"className":"wp-block-entry-content"} -->
					<div class="wp-block-group wp-block-entry-content"><!-- wp:heading {"style":{"typography":{"fontStyle":"normal","fontWeight":"400"}},"fontSize":"x-large"} -->
						<h2 class="wp-block-heading has-x-large-font-size" style="font-style:normal;font-weight:400"><?php esc_html_e('15 awesome things you can learn about great design.', 'infinix') ?></h2>
						<!-- /wp:heading -->

						<!-- wp:paragraph -->
						<p><?php esc_html_e('Blogs and websites tell a story or provide information about a product or service, so catching the attention of visitors is generally the primary goal.', 'infinix') ?></p>
						<!-- /wp:paragraph -->

						<!-- wp:buttons {"className":"btn-style-plain"} -->
						<div class="wp-block-buttons btn-style-plain"><!-- wp:button {"className":"is-style-fill"} -->
							<div class="wp-block-button is-style-fill"><a class="wp-block-button__link wp-element-button"><?php esc_html_e('Read More', 'infinix') ?></a></div>
							<!-- /wp:button -->
						</div>
						<!-- /wp:buttons -->
					</div>
					<!-- /wp:group -->
				</div>
				<!-- /wp:group -->
			</div>
			<!-- /wp:column -->

			<!-- wp:column -->
			<div class="wp-block-column"><!-- wp:group {"className":"wp-block-post-group"} -->
				<div class="wp-block-group wp-block-post-group"><!-- wp:image {"id":1885,"sizeSlug":"full","linkDestination":"none"} -->
					<figure class="wp-block-image size-full"><img src="<?php echo get_parent_theme_file_uri('/assets/images/featured-content-2.jpg'); ?>" alt="" class="wp-image-1885" /></figure>
					<!-- /wp:image -->

					<!-- wp:group {"className":"wp-block-entry-content"} -->
					<div class="wp-block-group wp-block-entry-content"><!-- wp:heading {"style":{"typography":{"fontStyle":"normal","fontWeight":"400"}},"fontSize":"x-large"} -->
						<h2 class="wp-block-heading has-x-large-font-size" style="font-style:normal;font-weight:400"><?php esc_html_e('Seven useful tips From expertes in design and wordPress.', 'infinix') ?></h2>
						<!-- /wp:heading -->

						<!-- wp:paragraph -->
						<p><?php esc_html_e('Featured content is the highlighted text, images, or posts on a page that entice visitors to read on. It looks like what you wanted and adjust as needed.', 'infinix') ?></p>
						<!-- /wp:paragraph -->

						<!-- wp:buttons {"className":"btn-style-plain"} -->
						<div class="wp-block-buttons btn-style-plain"><!-- wp:button {"className":"is-style-fill"} -->
							<div class="wp-block-button is-style-fill"><a class="wp-block-button__link wp-element-button"><?php esc_html_e('Read More', 'infinix') ?></a></div>
							<!-- /wp:button -->
						</div>
						<!-- /wp:buttons -->
					</div>
					<!-- /wp:group -->
				</div>
				<!-- /wp:group -->
			</div>
			<!-- /wp:column -->

			<!-- wp:column -->
			<div class="wp-block-column"><!-- wp:group {"className":"wp-block-post-group"} -->
				<div class="wp-block-group wp-block-post-group"><!-- wp:image {"id":1884,"sizeSlug":"full","linkDestination":"none"} -->
					<figure class="wp-block-image size-full"><img src="<?php echo get_parent_theme_file_uri('/assets/images/featured-content-3.jpg'); ?>" alt="" class="wp-image-1884" /></figure>
					<!-- /wp:image -->

					<!-- wp:group {"className":"wp-block-entry-content"} -->
					<div class="wp-block-group wp-block-entry-content"><!-- wp:heading {"style":{"typography":{"fontStyle":"normal","fontWeight":"400"}},"fontSize":"x-large"} -->
						<h2 class="wp-block-heading has-x-large-font-size" style="font-style:normal;font-weight:400"><?php esc_html_e('Five gigantic influences of gutenberg in the world of wordpress.', 'infinix') ?></h2>
						<!-- /wp:heading -->

						<!-- wp:paragraph -->
						<p><?php esc_html_e('Featured posts are typically your most popular or most recent articles, and they can help new readers discover your best content.', 'infinix') ?></p>
						<!-- /wp:paragraph -->

						<!-- wp:buttons {"className":"btn-style-plain"} -->
						<div class="wp-block-buttons btn-style-plain"><!-- wp:button {"className":"is-style-fill"} -->
							<div class="wp-block-button is-style-fill"><a class="wp-block-button__link wp-element-button"><?php esc_html_e('Read More', 'infinix') ?></a></div>
							<!-- /wp:button -->
						</div>
						<!-- /wp:buttons -->
					</div>
					<!-- /wp:group -->
				</div>
				<!-- /wp:group -->
			</div>
			<!-- /wp:column -->
		</div>
		<!-- /wp:columns -->
	</div>
	<!-- /wp:group -->
</div>
<!-- /wp:group -->
